/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import java.io.StringReader;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SdfFileInfo {
    private static final String ELEM_CARDINALITY = "cardinality";
    private static final String ELEM_CASE_PROPERTIES = "caseProperties";
    private static final String ELEM_CASE_TYPE = "caseType";
    private static final String ELEM_CASE_TYPES = "caseTypes";
    private static final String ELEM_CONTENT_ID = "content_id";
    private static final String ELEM_DISPLAY_NAME = "displayName";
    private static final String ELEM_GLOBAL_PROCESS_COLL = "globalProcessCollection";
    private static final String ELEM_ID = "id";
    private static final String ELEM_LOCAL_NAME = "localName";
    private static final String ELEM_NAME = "name";
    private static final String ELEM_PREFIX = "prefix";
    private static final String ELEM_PROCESS_CONFIG = "processConfiguration";
    private static final String ELEM_PROCESS_DEFINITION = "processDefinition";
    private static final String ELEM_PROPERTY_BOOLEAN = "propertyBooleanDefinition";
    private static final String ELEM_PROPERTY_DATETIME = "propertyDateTimeDefinition";
    private static final String ELEM_PROPERTY_DECIMAL = "propertyDecimalDefinition";
    private static final String ELEM_PROPERTY_INTEGER = "propertyIntegerDefinition";
    private static final String ELEM_PROPERTY_STRING = "propertyStringDefinition";
    private static final String ELEM_SOLUTION = "solution";
    private static final String ELEM_TASKS = "tasks";
    private static final String ELEM_TASK = "task";
    public static final String GLOBAL_PROCESS_COLLECTION = new VWString("vw.base.VWResource.solutionWorkflowCollection", "Solution Workflow Collection").toString();
    private String m_sdfFileContents = null;
    private String m_solutionName = null;
    private String m_solutionPrefix = null;
    private String m_processConfigGuid = null;
    private CEObjectInfo m_globalProcessCollectionObjectInfo = null;
    private ArrayList<CEObjectInfo> m_caseObjects = new ArrayList();
    private ArrayList<CEObjectInfo> m_taskObjects = new ArrayList();

    protected SdfFileInfo(String sdfFileContents, CEObjectInfo baseCaseFolder, CEObjectInfo baseCaseTask) throws Exception {
        InputSource inputSource = new InputSource(new StringReader(sdfFileContents));
        this.parseSdfFile(inputSource, baseCaseFolder, baseCaseTask);
    }

    public String getSolutionName() {
        return this.m_solutionName;
    }

    public String getSolutionPrefix() {
        return this.m_solutionPrefix;
    }

    public String getProcessConfigGuid() {
        return this.m_processConfigGuid;
    }

    public CEObjectInfo getGlobalProcessCollectionObjectInfo() {
        return this.m_globalProcessCollectionObjectInfo;
    }

    public CEObjectInfo[] getCaseObjects() {
        return this.m_caseObjects.toArray(new CEObjectInfo[0]);
    }

    public CEObjectInfo[] getTaskObjects() {
        return this.m_taskObjects.toArray(new CEObjectInfo[0]);
    }

    public String toString() {
        return this.m_sdfFileContents;
    }

    private void parseSdfFile(InputSource inputSource, CEObjectInfo baseCaseFolder, CEObjectInfo baseCaseTask) throws Exception {
        try {
            Node caseTypesNode;
            Node[] childNodes;
            String xpdlGuid;
            Node globalProcessCollNode;
            VWXMLWrapper xmlWrapper = new VWXMLWrapper(inputSource, null);
            this.m_sdfFileContents = xmlWrapper.toString();
            Node documentNode = xmlWrapper.getRootNode();
            if (documentNode == null || ELEM_SOLUTION.compareTo(documentNode.getLocalName()) != 0) {
                throw new VWException("filenet.vw.base.sdfFileInfo.NoSolutionTag", "The Solution Definition File (SDF) could not be parsed. \"sdf:solution\" tag was not found. Ensure the SDF is complete.");
            }
            this.m_solutionName = VWXMLWrapper.getNodeValue(documentNode, ELEM_NAME);
            this.m_solutionPrefix = VWXMLWrapper.getNodeValue(documentNode, ELEM_PREFIX);
            Node processConfigNode = VWXMLWrapper.getNodeNamed(documentNode, ELEM_PROCESS_CONFIG);
            if (processConfigNode != null) {
                this.m_processConfigGuid = VWXMLWrapper.getNodeValue(processConfigNode, ELEM_CONTENT_ID);
            }
            if ((globalProcessCollNode = VWXMLWrapper.getNodeNamed(documentNode, ELEM_GLOBAL_PROCESS_COLL)) != null && (xpdlGuid = VWXMLWrapper.getNodeValue(globalProcessCollNode, ELEM_CONTENT_ID)) != null) {
                this.m_globalProcessCollectionObjectInfo = new CEObjectInfo(xpdlGuid, GLOBAL_PROCESS_COLLECTION, GLOBAL_PROCESS_COLLECTION, xpdlGuid);
            }
            if ((childNodes = VWXMLWrapper.getNodesNamed(caseTypesNode = VWXMLWrapper.getNodeNamed(documentNode, ELEM_CASE_TYPES), ELEM_CASE_TYPE)) != null) {
                for (int i = 0; i < childNodes.length; ++i) {
                    Node[] childTaskNodes;
                    String id = VWXMLWrapper.getNodeValue(childNodes[i], ELEM_ID);
                    if (id == null || id.length() <= 0) continue;
                    String displayName = VWXMLWrapper.getNodeValue(childNodes[i], ELEM_DISPLAY_NAME);
                    String symbolicName = VWXMLWrapper.getNodeValue(childNodes[i], ELEM_NAME);
                    String xpdlGuid2 = null;
                    Node processDefNode = VWXMLWrapper.getNodeNamed(childNodes[i], ELEM_PROCESS_DEFINITION);
                    if (processDefNode != null) {
                        xpdlGuid2 = VWXMLWrapper.getNodeValue(processDefNode, ELEM_CONTENT_ID);
                    }
                    CEObjectInfo ceObjInfo = new CEObjectInfo(id, displayName, symbolicName, xpdlGuid2);
                    if (baseCaseFolder != null) {
                        ceObjInfo.bootstrapPropertyLists(baseCaseFolder);
                    }
                    this.parseCaseProperties(VWXMLWrapper.getNodeNamed(childNodes[i], ELEM_CASE_PROPERTIES), ceObjInfo);
                    this.m_caseObjects.add(ceObjInfo);
                    Node caseTasksNode = VWXMLWrapper.getNodeNamed(childNodes[i], ELEM_TASKS);
                    if (caseTasksNode == null || (childTaskNodes = VWXMLWrapper.getNodesNamed(caseTasksNode, ELEM_TASK)) == null) continue;
                    for (int j = 0; j < childTaskNodes.length; ++j) {
                        String taskId = VWXMLWrapper.getNodeValue(childTaskNodes[j], ELEM_ID);
                        if (taskId == null || taskId.length() <= 0) continue;
                        String taskDisplayName = VWXMLWrapper.getNodeValue(childTaskNodes[j], ELEM_DISPLAY_NAME);
                        String taskSymbolicName = VWXMLWrapper.getNodeValue(childTaskNodes[j], ELEM_NAME);
                        CEObjectInfo taskInfo = new CEObjectInfo(taskId, taskDisplayName, taskSymbolicName);
                        if (baseCaseTask != null) {
                            taskInfo.bootstrapPropertyLists(baseCaseTask);
                        }
                        this.m_taskObjects.add(taskInfo);
                    }
                }
            }
        }
        catch (SAXParseException saxEx) {
            VWString parsingError = new VWString("filenet.vw.base.sdfFileInfo.parsingError", "** Parsing error");
            VWString line = new VWString("filenet.vw.base.sdfFileInfo.line", "line");
            String errString = parsingError + ", " + line + " " + saxEx.getLineNumber() + ", uri " + saxEx.getSystemId() + "\n" + "   " + saxEx.getMessage();
            VWException theException = new VWException("filenet.vw.base.sdfFileInfo.SDFReadParse", "SDF parsing error {0}.", errString);
            theException.setCause(saxEx);
            throw theException;
        }
    }

    private void parseCaseProperties(Node casePropsNode, CEObjectInfo ceObjInfo) {
        int i;
        if (casePropsNode == null) {
            return;
        }
        Node[] childNodes = VWXMLWrapper.getNodesNamed(casePropsNode, ELEM_PROPERTY_BOOLEAN);
        if (childNodes != null) {
            for (i = 0; i < childNodes.length; ++i) {
                this.addCaseProperty(childNodes[i], 4, ceObjInfo);
            }
        }
        if ((childNodes = VWXMLWrapper.getNodesNamed(casePropsNode, ELEM_PROPERTY_DATETIME)) != null) {
            for (i = 0; i < childNodes.length; ++i) {
                this.addCaseProperty(childNodes[i], 16, ceObjInfo);
            }
        }
        if ((childNodes = VWXMLWrapper.getNodesNamed(casePropsNode, ELEM_PROPERTY_DECIMAL)) != null) {
            for (i = 0; i < childNodes.length; ++i) {
                this.addCaseProperty(childNodes[i], 8, ceObjInfo);
            }
        }
        if ((childNodes = VWXMLWrapper.getNodesNamed(casePropsNode, ELEM_PROPERTY_INTEGER)) != null) {
            for (i = 0; i < childNodes.length; ++i) {
                this.addCaseProperty(childNodes[i], 1, ceObjInfo);
            }
        }
        if ((childNodes = VWXMLWrapper.getNodesNamed(casePropsNode, ELEM_PROPERTY_STRING)) != null) {
            for (i = 0; i < childNodes.length; ++i) {
                this.addCaseProperty(childNodes[i], 2, ceObjInfo);
            }
        }
    }

    private void addCaseProperty(Node casePropNode, int nFieldType, CEObjectInfo ceObjInfo) {
        String localName = VWXMLWrapper.getNodeValue(casePropNode, ELEM_LOCAL_NAME);
        boolean bIsArray = false;
        String cardinality = VWXMLWrapper.getNodeValue(casePropNode, ELEM_CARDINALITY);
        if (cardinality != null && cardinality.length() > 0 && cardinality.compareTo("single") != 0) {
            bIsArray = true;
        }
        if (localName != null && localName.length() > 0) {
            ceObjInfo.setPropertyType(localName, nFieldType, bIsArray);
        }
    }
}

